﻿<%@ Control Language="C#" Inherits="System.Web.Mvc.ViewUserControl<SearchViewModel>" %>
<div id="searchResults" class="panel">
    <div class="items">
        <% if(Model.Items != null) %>
        <% { %>
            <hr />
            <% if (Model.TotalPages == 0) %>
            <% { %>
                <h3>No activities found...</h3>
            <% } else {%>
                <ul class="activities">
                    <% foreach(var activity in (IEnumerable<ActivityViewModel>)Model.Items) %>
                    <% { %>
                    <li>
                        <h3><%:activity.Entity.Name%></h3>
                        <p>
                            <%:activity.Entity.Street%><br />
                            <%:activity.Entity.City%>, <%:activity.Entity.State%> <%:activity.Entity.Zip%> | Phone: <%:activity.Entity.PhoneNumber%><br />
                            » <%=Html.ActionLink<ItinerariesController>(c => c.AddActivity(activity.Entity.Id, null), "Add to Itinerary", new { @class = "btn add" })%>
                        </p>
                    </li>
                    <% } %>
                </ul>
            <% } %>
        <% } %>
    </div>
    
    <% if (Model.TotalPages > 0) %>
    <% { %>
         <div class="pager">
            <% if (string.IsNullOrEmpty(Model.PreviousPageLink)) %>
            <% { %>
                « Previous
            <% } else { %>
                <a href="<%=Html.AttributeEncode(Model.PreviousPageLink)%>">« Previous</a>
            <% } %>
            |
            <strong>Page <%=Model.CurrentPage%></strong>
            |
            <% if (string.IsNullOrEmpty(Model.NextPageLink)) %>
            <% { %>
                Next »
            <% } else { %>
                <a href="<%=Html.AttributeEncode(Model.NextPageLink)%>">Next »</a>
            <% } %>
        </div>
    <% } %>
</div>